// Rad_Fade.js | Radnen 2008 // v1.4
// - Jul, 15, 2008 - Fixed: image blink before fade occurs.
// - Jul, 14, 2008 - Moved: Now part of the RadLib Library.
// - Jun, 23, 2008 - Added: FaderEngine.waitForFade();
// - Jun, 23, 2008 - Added: FaderEngine.setColor();
// - Jun, 21, 2008 - Fixed: Update loop now does time-based drawing.
// - Feb, 14, 2008 - Added: FaderEngine.clear();

// I offer a night/morning time values to use in the engine //
const NIGHT = CreateColor(10, 10, 40, 0);
const MORNING = CreateColor(255, 230, 180, 0);

// This is the engine, a game will typically consist of 1 engine //
// A second engine may be used separately for day/night however //
function FaderEngine()
{
	if (this instanceof FaderEngine == false)
	{
		return new FaderEngine();
	}

	this.color = CreateColor(0, 0, 0, 0);
	this.ticks = 0;
	this.msecs = 0;
	this.time = 0;
	this.max = 255;
	this.fade = 0;
	this.done = true;
}

// Call this whenever you want to fade the screen in //
FaderEngine.prototype.fadeIn = function(msecs)
{
	this.msecs = msecs;
	this.time = GetTime();
	this.fade = FADE_IN;
	this.color.alpha = 0;
	this.done = false;
}

// Call this whenever you want to fade the screen out //
FaderEngine.prototype.fadeOut = function(msecs)
{
	this.msecs = msecs;
	this.time = GetTime();
	this.fade = FADE_OUT;
	this.color.alpha = 255;
	this.done = false;
}

// Call this whenever you want to immediately stop a fade or clear the screen from a fade out //
FaderEngine.prototype.clear = function()
{
	this.fade = 0;
	this.msecs = 0;
	this.time = 0;
	this.color.alpha = 0;
	this.done = true;
}

// Used to finish a fade immediately. Useful for long fades that can be player skipped(?).
FaderEngine.prototype.forceFinish = function()
{
	this.fade = 0;
	this.msecs = 0;
	this.time = 0;
	(this.fade == 1) ? this.color.alpha = 0 : this.color.alpha = this.max;
	this.done = true;
}

// Use this to set the fade color.
FaderEngine.prototype.setColor = function(color)
{
	this.color = color;
	this.color.alpha = 0;
}

FaderEngine.prototype.waitForFade = function()
{
	SetFrameRate(GetMapEngineFrameRate());
	while(!this.done)
	{
		UpdateMapEngine();
		RenderMap();
		FlipScreen();
	}
	SetFrameRate(0);
}

// This is put inside a RenderScript();
FaderEngine.prototype.update = function()
{
	if (this.fade == 0)
	{
		if (!this.done) this.done = true;
	}
	
	Rectangle(0, 0, SW, SH, this.color);

	// Fade In:
	if (this.fade == 1)
	{
		if (this.time + this.msecs > GetTime())
		{
			this.color.alpha = (GetTime() - this.time) * this.max / this.msecs;
			if (this.color.alpha > 255) this.color.alpha = 255;
		}
		else this.fade = 0;
	}
	
	// Fade Out:
	if (this.fade == 2)
	{
		if (this.time + this.msecs > GetTime())
		{
			this.color.alpha = this.max - (GetTime() - this.time) * this.max / this.msecs;
		}
		else this.fade = 0;
	}
}